<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


class CFileListWidgetFile extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "1",
		"name"	=> "File List",
	);


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $base;

		switch ($widget["settings"]["set_show"]) {
			//latest
			case "1":
				$order = "item_date ASC";

				if ($widget["settings"]["set_cat"]) {
					$tmp = explode("," , $widget["settings"]["set_cat"]);
					foreach ($tmp as $k => $v) {
						if ($v) {
							$_cond[] = "find_in_set($v , item_cat) ";
						}				
					}

					if (is_array($_cond)) {
						$cond = " AND ( " . implode(" OR "  , $_cond ) . ") ";
					}							
				}

			break;

			//manual
			case "2":
				$order = "item_der ASC";
			break;

			default:
				return "";
			break;
		}

		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:filelist_items']} as i , 
				{$this->tables['plugin:filelist_items_lang']} as l 
			WHERE
				i.item_id = l.item_id and 
				i.module_id = {$widget[mod_id]} AND 
				l.lang_id = {$widget[lang_id]} {$cond}
			ORDER BY 
				{$order}
			LIMIT {$widget[settings][set_items]}
			"
		);	

		if (!is_array($items)) {
			return "";
		}

		foreach ($items as $key => $val) {			
			$items[$key]["icon"] = $this->tpl->blockreplace($val["item_icon"] ? "Icon" : "NoIcon" , $val );									
			$items[$key]["link"] = $widget["link"] . "dl/" . $val["item_code"];
		}		

		
		return $this->tpl->blockReplace(
			"Main" , 
			array(
				"items"	=> $base->html->Table(
					$this->tpl , 
					"" , 
					$items,
					array(
						"collapsed"	=> $widget["settings"]["set_first"] ? "true" : "false",
					)
				),				
			),
			$widget ,
			$widget["settings"],
			$widget["mod_settings"]
		);
	}
	
	

}


?>